<?php
include '../includes/auth.php';
include '../config/db.php';

// Check if transaction ID is provided
$transaction_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Get transaction details
$sql = "SELECT ft.*, s.first_name, s.last_name, s.admission_number, 
               c.class_name, fs.total_fee
        FROM fee_transactions ft
        JOIN students s ON ft.student_id = s.student_id
        JOIN classes c ON s.class_id = c.class_id
        JOIN fee_structure fs ON s.class_id = fs.class_id
        WHERE ft.transaction_id = $transaction_id";
$result = $conn->query($sql);

if ($result->num_rows == 0) {
    die("Transaction not found");
}

$transaction = $result->fetch_assoc();

// Get monthly payments
$sql = "SELECT payment_month FROM monthly_payments 
        WHERE transaction_id = $transaction_id";
$result = $conn->query($sql);
$paid_months = [];
while ($row = $result->fetch_assoc()) {
    $paid_months[] = $row['payment_month'];
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $amount_paid = $conn->real_escape_string($_POST['amount_paid']);
    $payment_mode = $conn->real_escape_string($_POST['payment_mode']);
    $payment_details = $conn->real_escape_string($_POST['payment_details'] ?? '');
    $remarks = $conn->real_escape_string($_POST['remarks'] ?? '');
    $months = isset($_POST['months']) ? $_POST['months'] : [];
    
    // Calculate new balance
    $sql = "SELECT SUM(amount_paid) as total_paid 
            FROM fee_transactions 
            WHERE student_id = {$transaction['student_id']} 
            AND transaction_id != $transaction_id";
    $result = $conn->query($sql);
    $other_payments = $result->fetch_assoc()['total_paid'] ?? 0;
    $new_total_paid = $other_payments + $amount_paid;
    $balance_amount = $transaction['total_fee'] - $new_total_paid;
    
    // Start transaction
    $conn->begin_transaction();
    
    try {
        // Update transaction
        $sql = "UPDATE fee_transactions SET 
                amount_paid = $amount_paid,
                payment_mode = '$payment_mode',
                payment_details = '$payment_details',
                balance_amount = $balance_amount,
                remarks = '$remarks'
                WHERE transaction_id = $transaction_id";
        
        if ($conn->query($sql) === TRUE) {
            // Delete existing monthly payments
            $sql = "DELETE FROM monthly_payments WHERE transaction_id = $transaction_id";
            $conn->query($sql);
            
            // Insert new monthly payments
            if (!empty($months)) {
                foreach ($months as $month) {
                    $month = $conn->real_escape_string($month);
                    $sql = "INSERT INTO monthly_payments (
                                transaction_id, student_id, payment_month, 
                                payment_year, amount
                            ) VALUES (
                                $transaction_id, {$transaction['student_id']}, $month,
                                YEAR(CURRENT_DATE()), " . ($amount_paid / count($months)) . "
                            )";
                    $conn->query($sql);
                }
            }
            
            $conn->commit();
            header("Location: receipt.php?id=$transaction_id");
            exit();
        } else {
            throw new Exception("Error updating transaction: " . $conn->error);
        }
    } catch (Exception $e) {
        $conn->rollback();
        $error = "Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Transaction</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/dashboard.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/header-internal.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Edit Transaction</h1>
                </div>
                
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <div class="card">
                    <div class="card-body">
                        <form method="POST">
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Student Name</label>
                                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($transaction['first_name'] . ' ' . $transaction['last_name']); ?>" readonly>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Admission Number</label>
                                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($transaction['admission_number']); ?>" readonly>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Class</label>
                                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($transaction['class_name']); ?>" readonly>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Receipt Number</label>
                                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($transaction['receipt_number']); ?>" readonly>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Total Fee</label>
                                    <input type="text" class="form-control" value="₹<?php echo number_format($transaction['total_fee'], 2); ?>" readonly>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Current Balance</label>
                                    <input type="text" class="form-control" value="₹<?php echo number_format($transaction['balance_amount'], 2); ?>" readonly>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Select Months *</label>
                                <div class="row" id="monthSelection">
                                    <?php
                                    $months = [
                                        13=> "Term-1" , 6 => 'June',
                                        7 => 'July', 8 => 'August', 9 => 'September',
                                        10 => 'October', 11 => 'November',14 => 'Term-2', 12 => 'December',1 => 'January', 2 => 'February', 3 => 'March',
                                        4 => 'April', 5 => 'May'
                                    ];
                                    foreach ($months as $num => $name) {
                                        $checked = in_array($num, $paid_months) ? 'checked' : '';
                                        echo "<div class='col-md-3 mb-2'>
                                                <div class='form-check'>
                                                    <input class='form-check-input month-checkbox' type='checkbox' 
                                                           name='months[]' value='$num' id='month$num' $checked>
                                                    <label class='form-check-label' for='month$num'>$name</label>
                                                </div>
                                            </div>";
                                    }
                                    ?>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="amount_paid" class="form-label">Amount to Pay *</label>
                                <input type="number" class="form-control" id="amount_paid" name="amount_paid" required step="0.01" value="<?php echo $transaction['amount_paid']; ?>">
                            </div>
                            
                            <div class="mb-3">
                                <label for="payment_mode" class="form-label">Payment Mode *</label>
                                <select class="form-select" id="payment_mode" name="payment_mode" required>
                                    <option value="">Select Mode</option>
                                    <option value="Cash" <?php echo $transaction['payment_mode'] == 'Cash' ? 'selected' : ''; ?>>Cash</option>
                                    <option value="Gpay" <?php echo $transaction['payment_mode'] == 'Gpay' ? 'selected' : ''; ?>>Gpay</option>
                                    <option value="Cheque" <?php echo $transaction['payment_mode'] == 'Cheque' ? 'selected' : ''; ?>>Cheque</option>
                                    <option value="Online Transfer" <?php echo $transaction['payment_mode'] == 'Online Transfer' ? 'selected' : ''; ?>>Online Transfer</option>
                                    <option value="DD" <?php echo $transaction['payment_mode'] == 'DD' ? 'selected' : ''; ?>>DD</option>
                                </select>
                            </div>
                            
                            <div class="mb-3" id="paymentDetailsContainer" style="display: <?php echo $transaction['payment_mode'] == 'Cash' ? 'none' : 'block'; ?>;">
                                <label for="payment_details" class="form-label">Payment Details</label>
                                <input type="text" class="form-control" id="payment_details" name="payment_details" value="<?php echo htmlspecialchars($transaction['payment_details']); ?>" placeholder="Cheque no/Transaction reference">
                            </div>
                            
                            <div class="mb-3">
                                <label for="remarks" class="form-label">Remarks</label>
                                <textarea class="form-control" id="remarks" name="remarks" rows="2"><?php echo htmlspecialchars($transaction['remarks']); ?></textarea>
                            </div>
                            
                            <div class="mb-3">
                                <button type="submit" class="btn btn-primary">Update Transaction</button>
                                <a href="javascript:history.back()" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Show payment details field when not Cash
            const paymentMode = document.getElementById('payment_mode');
            if (paymentMode) {
                paymentMode.addEventListener('change', function() {
                    const detailsContainer = document.getElementById('paymentDetailsContainer');
                    const paymentDetails = document.getElementById('payment_details');
                    if (detailsContainer) {
                        detailsContainer.style.display = this.value === 'Cash' ? 'none' : 'block';
                        paymentDetails.required = this.value !== 'Cash';
                    }
                });
            }

            // Update amount when months are selected
            document.querySelectorAll('.month-checkbox').forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    const totalFee = <?php echo $transaction['total_fee']; ?>;
                    const selectedMonths = document.querySelectorAll('.month-checkbox:checked');
                    const totalMonths = 14; // Total number of months including terms
                    const monthlyAmount = totalFee / totalMonths;
                    
                    // Calculate amount based on selected months
                    let totalAmount = 0;
                    selectedMonths.forEach(month => {
                        const monthValue = parseInt(month.value);
                        totalAmount += monthlyAmount;
                    });
                    
                    document.getElementById('amount_paid').value = totalAmount.toFixed(2);
                });
            });
        });
    </script>
</body>
</html> 