<?php
require_once __DIR__ . '/auth.php';
requireAuth();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' | School Fee System' : 'School Fee System'; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    
    <!-- Custom CSS -->
    <link href="./assets/css/style.css" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" href="./assets/images/favicon.ico" type="image/x-icon">
    
    <style>
        .navbar-brand {
            font-weight: 600;
        }
        .navbar-brand img {
            height: 30px;
            margin-right: 10px;
        }
        .user-dropdown .dropdown-toggle::after {
            display: none;
        }
        .user-avatar {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            margin-right: 8px;
            object-fit: cover;
        }
        .notification-badge {
            position: absolute;
            top: 0;
            right: 0;
            font-size: 0.6rem;
        }
        .sidebar-toggle {
            cursor: pointer;
            margin-right: 10px;
        }
    </style>
</head>
<body>
    <!-- Top Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-dark shadow-sm"  style=" background-color: brown;">
        <div class="container-fluid">
            <!-- Sidebar Toggle (Visible on mobile) -->
            <span class="sidebar-toggle d-lg-none text-white me-2">
                <i class="fas fa-bars fa-lg"></i>
            </span>
            
            <!-- School Logo and Name -->
           <a class="navbar-brand d-flex align-items-center" href="./dashboard.php">
                <!-- <img src="./assets/images/school-logo.png" alt="School Logo" class="d-inline-block" onerror="this.style.display='none'"> -->
                <h3 style="text-align: center;color: #ffff;">DIVINE CHILD HIGH SCHOOL</h3>
                <!-- <span>School Fee System</span> -->
            </a>
            
            <!-- Mobile Toggle Button -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <!-- Navigation Links -->
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <!-- Notifications Dropdown -->
                    <li class="nav-item dropdown me-2">
                        <a class="nav-link dropdown-toggle position-relative" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-bell"></i>
                            <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger notification-badge">
                                3
                            </span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><h6 class="dropdown-header">Notifications</h6></li>
                            <li><a class="dropdown-item" href="#"><i class="fas fa-money-bill-wave text-success me-2"></i> New payment received</a></li>
                            <li><a class="dropdown-item" href="#"><i class="fas fa-exclamation-triangle text-warning me-2"></i> 5 fee defaulters</a></li>
                            <li><a class="dropdown-item" href="#"><i class="fas fa-calendar-day text-info me-2"></i> Due date approaching</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-center" href="#">View all</a></li>
                        </ul>
                    </li>
                    
                    <!-- User Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center user-dropdown" href="#" role="button" data-bs-toggle="dropdown">
                            <img src="./assets/images/user-avatar.png" alt="User Avatar" class="user-avatar" onerror="this.src='./assets/images/default-avatar.png'">
                            <span><?php echo htmlspecialchars($_SESSION['full_name']); ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <div class="dropdown-header text-center">
                                    <strong><?php echo htmlspecialchars($_SESSION['full_name']); ?></strong>
                                    <div class="small text-muted"><?php echo ucfirst($_SESSION['role']); ?></div>
                                </div>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="./profile.php"><i class="fas fa-user me-2"></i> Profile</a></li>
                            <li><a class="dropdown-item" href="./settings/"><i class="fas fa-cog me-2"></i> Settings</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="./logout.php"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    
    <!-- Main Container -->
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar (Included separately) -->
            <?php 
            include 'sidebar.php'; 
            ?>
            
            <!-- Main Content Area -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <!-- Flash Messages -->
                <?php $successMessage = getFlashMessage('success'); ?>
                <?php if ($successMessage): ?>
                    <div class="alert alert-success alert-dismissible fade show">
                        <?php echo $successMessage; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                
                <?php $errorMessage = getFlashMessage('error'); ?>
                <?php if ($errorMessage): ?>
                    <div class="alert alert-danger alert-dismissible fade show">
                        <?php echo $errorMessage; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>