<?php
require_once __DIR__ . '/auth.php';
requireAuth();
?>

<!-- Sidebar -->
<div class="col-md-3 col-lg-2 d-md-block sidebar collapse">
    <div class="position-sticky pt-3">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>" href="./dashboard.php">
                    <i class="fas fa-tachometer-alt"></i>
                    Dashboard
                </a>
            </li>
            
            <?php if (hasRole('admin') || hasRole('accountant')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'collect.php' ? 'active' : ''; ?>" href="./fees/collect.php">
                    <i class="fas fa-money-bill-wave"></i>
                    Collect Fees
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'students') !== false ? 'active' : ''; ?>" href="./students/students.php">
                    <i class="fas fa-users"></i>
                    Students
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'transactions/') !== false ? 'active' : ''; ?>" href="./transactions/index.php">
                    <i class="fas fa-receipt"></i>
                    Transactions
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (hasRole('admin')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'reports/') !== false ? 'active' : ''; ?>" href="./reports/index.php">
                    <i class="fas fa-chart-bar"></i>
                    Reports
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'settings/') !== false ? 'active' : ''; ?>" href="./settings/">
                    <i class="fas fa-cog"></i>
                    Settings
                </a>
            </li>
            <?php endif; ?>
        </ul>
        
        <?php if (hasRole('admin')): ?>
        <hr class="mt-3 mb-2 text-white-50">
        <h6 class="sidebar-heading px-3 mt-2 mb-1 text-muted text-uppercase">
            <span>Administration</span>
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>" href="./admin/users.php">
                    <i class="fas fa-user-shield"></i>
                    User Management
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'fee-structure.php' ? 'active' : ''; ?>" href="./admin/fee-structure.php">
                    <i class="fas fa-table"></i>
                    Fee Structure
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'classes.php' ? 'active' : ''; ?>" href="./admin/classes.php">
                    <i class="fas fa-chalkboard"></i>
                    Class Management
                </a>
            </li>
        </ul>
        <?php endif; ?>
        
        <hr class="mt-3 mb-2 text-white-50">
        <div class="px-3">
            <div class="text-center text-white-50 small">
                <div class="mb-1">School Fee System</div>
                <div>v1.0.0</div>
            </div>
        </div>
    </div>
</div>