<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/db.php';

// Check if admin
if (!hasRole('admin')) {
    header("Location: /dashboard.php");
    exit();
}

// Set page title
$pageTitle = "System Settings";

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Process settings update here
    setFlashMessage('success', 'Settings updated successfully');
    header("Location: index.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
   <?php include '../includes/header-internal.php'; ?>
</head>
<body>
 
    <div class="container-fluid">
        <div class="row">
       
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">System Settings</h1>
                </div>
                
                <div class="row">
                    <div class="col-md-8">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5>General Settings</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST">
                                    <div class="mb-3">
                                        <label for="school_name" class="form-label">School Name</label>
                                        <input type="text" class="form-control" id="school_name" name="school_name" value="DIVINE CHILD HIGH SCHOOL">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="school_address" class="form-label">School Address</label>
                                        <textarea class="form-control" id="school_address" name="school_address" rows="3">Indira Nagar, Behind Dindoshi Court, Rani Sati Marg, Malad East-400097</textarea>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="school_phone" class="form-label">Contact Number</label>
                                            <input type="text" class="form-control" id="school_phone" name="school_phone" value="022-28409758">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="school_email" class="form-label">Email Address</label>
                                            <input type="email" class="form-control" id="school_email" name="school_email" value="">
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="academic_year" class="form-label">Current Academic Year</label>
                                        <input type="text" class="form-control" id="academic_year" name="academic_year" value="2024-25">
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary">Save Settings</button>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5>Receipt Settings</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST">
                                    <div class="mb-3">
                                        <label for="receipt_prefix" class="form-label">Receipt Prefix</label>
                                        <input type="text" class="form-control" id="receipt_prefix" name="receipt_prefix" value="CR/SC">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="receipt_start" class="form-label">Receipt Starting Number</label>
                                        <input type="number" class="form-control" id="receipt_start" name="receipt_start" value="1001">
                                    </div>
                                    
                                    <div class="mb-3 form-check">
                                        <input type="checkbox" class="form-check-input" id="auto_increment" name="auto_increment" checked>
                                        <label class="form-check-label" for="auto_increment">Auto-increment receipt numbers</label>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary">Save Settings</button>
                                </form>
                            </div>
                        </div>
                        
                        <div class="card">
                            <div class="card-header">
                                <h5>System Maintenance</h5>
                            </div>
                            <div class="card-body">
                                <div class="d-grid gap-2">
                                    <button class="btn btn-outline-secondary" type="button">Backup Database</button>
                                    <button class="btn btn-outline-danger" type="button" onclick="return confirm('Are you sure? This will clear all temporary data.')">Clear Cache</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
<!-- Custom JS -->
    <script src="../assets/js/main.js"></script>
    <?php include '../includes/footer.php'; ?>
</body>
</html>