<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/db.php';
// Set page title
$pageTitle = "Fee Transactions";

// Get all transactions with student and class information
$sql = "SELECT ft.*, s.first_name, s.last_name, s.admission_number, c.class_name
        FROM fee_transactions ft
        JOIN students s ON ft.student_id = s.student_id
        JOIN classes c ON s.class_id = c.class_id
        ORDER BY ft.transaction_date DESC";
$result = $conn->query($sql);
$transactions = $result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    
</head>
<body>
     <?php include '../includes/header-internal.php'; ?>
    <div class="container-fluid">
        <div class="row">
          
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Fee Transactions</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
                        </div>
                    </div>
                </div>
                
                <div class="table-responsive">
                    <table class="table table-striped table-hover data-table">
                        <thead>
                            <tr>
                                <th>Receipt No</th>
                                <th>Date</th>
                                <th>Student</th>
                                <th>Class</th>
                                <th>Amount</th>
                                <th>Mode</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($transactions as $txn): ?>
                            <tr>
                                <td><?= htmlspecialchars($txn['receipt_number']) ?></td>
                                <td><?= date('d/m/Y', strtotime($txn['transaction_date'])) ?></td>
                                <td><?= htmlspecialchars($txn['first_name'] . ' ' . $txn['last_name']) ?></td>
                                <td><?= htmlspecialchars($txn['class_name']) ?></td>
                                <td>₹<?= number_format($txn['amount_paid'], 2) ?></td>
                                <td><?= htmlspecialchars($txn['payment_mode']) ?></td>
                                <td>
                                    <a href="../fees/receipt.php?id=<?= $txn['transaction_id'] ?>" class="btn btn-sm btn-primary" target="_blank">
                                        <i class="fas fa-print"></i> Receipt
                                    </a>
                                    <a href="../fees/edit_transaction.php?id=<?= $txn['transaction_id'] ?>" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
</body>
</html>